//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - JEI Hide
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
// Contributors: ShiftTheDev, ChosenArchitect
//
// Hides things from JEI
//------------------------------------------------------------------------------------------------------------------------------------------------

// Simple remove list
const toRemove = [
    "projectexpansion:compact_sun",
	"draconicevolution:info_tablet",
	"quark:obsidian_pressure_plate",
	"cyclic:compressed_cobblestone",
	"jaopca:storage_blocks.brick",
	"jaopca:storage_blocks.alfsteel",
	"jaopca:storage_blocks.fluix",
	"jaopca:storage_blocks.glowstone",
	"jaopca:storage_blocks.brick",
	"jaopca:storage_blocks.necronium",
	"jaopca:storage_blocks.nether_brick",
	"jaopca:storage_blocks.skyjade",
	"jaopca:storage_blocks.soul_steel",
	"jaopca:storage_blocks.stratus",
	"jaopca:storage_blocks.veridium",
	"jaopca:storage_blocks.zanite",
	"jaopca:storage_blocks.wood",
	/chisel_chipped_integration:metal_aluminum_.*/,
	/chisel_chipped_integration:metal_cobalt_.*/,
	/chisel_chipped_integration:metal_platinum_.*/,
	"chisel_chipped_integration:technical_massive_hexagonal_plating_corner_bottom_left",
	"chisel_chipped_integration:technical_massive_fan_edge_right",
	"chisel_chipped_integration:technical_massive_hexagonal_plating_edge_right",
	"chisel_chipped_integration:technical_massive_fan_corner_top_left",
	"chisel_chipped_integration:technical_massive_hexagonal_plating_corner_bottom_right",
	"chisel_chipped_integration:technical_massive_hexagonal_plating_edge_left",
	"chisel_chipped_integration:technical_massive_fan_corner_bottom_left",
	"chisel_chipped_integration:technical_massive_fan_edge_top",
	"chisel_chipped_integration:technical_massive_fan_corner_bottom_right",
	"chisel_chipped_integration:technical_massive_hexagonal_plating_corner_top_right",
	"chisel_chipped_integration:technical_massive_fan_edge_bottom",
	"chisel_chipped_integration:technical_massive_hexagonal_plating_corner_top_left",
	"chisel_chipped_integration:technical_massive_hexagonal_plating_edge_top",
	"chisel_chipped_integration:technical_massive_hexagonal_plating_edge_bottom",
	"chisel_chipped_integration:technical_massive_fan_edge_left",
	"chisel_chipped_integration:technical_massive_fan_corner_top_right",
	"chisel_chipped_integration:technical_make_shift_plating_edge_left",
	"chisel_chipped_integration:technical_make_shift_plating_corner_bottom_right",
	"chisel_chipped_integration:technical_make_shift_plating_corner_top_right",
	"chisel_chipped_integration:technical_make_shift_plating_edge_top",
	"chisel_chipped_integration:technical_make_shift_plating_edge_right",
	"chisel_chipped_integration:technical_make_shift_plating_corner_top_left",
	"chisel_chipped_integration:technical_make_shift_plating_edge_bottom",
	"chisel_chipped_integration:technical_make_shift_plating_corner_bottom_left",
	"chisel_chipped_integration:factory_old_vents_edge_top",
	"chisel_chipped_integration:factory_old_vents_corner_top_right",
	"chisel_chipped_integration:factory_old_vents_edge_bottom",
	"chisel_chipped_integration:factory_old_vents_edge_left",
	"chisel_chipped_integration:factory_old_vents_corner_bottom_left",
	"chisel_chipped_integration:factory_old_vents_corner_top_left",
	"chisel_chipped_integration:factory_old_vents_edge_right",
	"chisel_chipped_integration:factory_old_vents_corner_bottom_right",
	"architects_palette:charcoal_block",
    "industrialforegoing:tinydryrubber",
    "create:crushed_raw_platinum",
    "create:crushed_raw_aluminum",
    "create:crushed_raw_quicksilver",
    "thermal:ruby_gear",
    "thermal:sapphire_gear",
    "thermal_extra:arcane_gold_dust",
    "jaopca:storage_blocks.arcane_gold",
    "#projectexpansion:collector", 
    "#projectexpansion:compressed_collector", 
    "#projectexpansion:power_flower", 
    "#projectexpansion:relay",
    "jaopca:dusts.zinc",
    "thermal:ender_pearl_dust",
    "thermal:sawdust",
    "createaddition:electrum_rod",
    "createdeco:iron_coin",
    "createdeco:gold_coin",
    "createdeco:copper_coin",
    "createdeco:netherite_coin",
    "createaddition:copper_rod",
    "createaddition:iron_rod",
    "createaddition:gold_rod",
    "createaddition:electrum_rod",
    "thermal_extra:aluminum_ore_chunk",
    "thermal_extra:arcane_gold_ore_chunk",
    "thermal_extra:raw_aluminum_bucket",
    "thermal_extra:raw_arcane_gold_bucket",
    "architects_palette:ender_pearl_block",
    "cyclic:honey_bucket",
    "create:honey_bucket",
	"outer_end:ominous_miasma_bucket",
	"biggerreactors:steam_bucket",
	"enlightened_end:chorus_soup",
	"cyclic:mob_container"
];

// Remove List for Fluids
const toRemoveFluids = [
    "thermal_extra:raw_aluminum",
    "thermal_extra:raw_arcane_gold",
    "create:honey",
    "cofh_core:honey",
    "cyclic:honey"
];

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// The events to hide the items & fluids
const $VanillaTypes = Java.loadClass("mezz.jei.api.constants.VanillaTypes");
JEIEvents.hideItems(event => {
    toRemove.forEach(item => event.hide(item));

    const hidden = Utils.newList();
    event.getAllIngredients().forEach(ing => {
        if (ing.getId() === "mekanism:creative_fluid_tank" && ing.nbt && toRemoveFluids.includes(ing.nbt.mekData.FluidTanks[0].stored.FluidName))
            hidden.add(ing);
    });

    global.jeiRuntime.getIngredientManager().removeIngredientsAtRuntime($VanillaTypes.ITEM_STACK, hidden);
});

JEIEvents.hideFluids(event => {
    toRemoveFluids.forEach(fuild => event.hide(fuild));
});